Attribute VB_Name = "cubeDevelopment"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

' VB example for development of a Cube.
'       Steps
'               - Creates a Cube on the base Workplane.
'               - Calls the  module 'cubeDevelopment'

'Define a Global Variable to hold the ProDESKTOP Application Object
Public app As ProDESKTOP

Public Sub CubeDevelopmentExample()

'Call the subroutine createCube to create a cube on the base workplane
Call createCube

'Call the subroutine cubeDevelopment
Call cubeDevelopment

End Sub

'Subroutine to create a cube on the base workplane
Private Sub createCube()

'Get the ProDESKTOP Application Object
GetApplicationObject
app.SetVisible (True)

'Create a New Part
Dim part As PartDocument
Set part = app.NewPart

Dim api As helm
Set api = app.TakeHelm

'Get the active workplane
Dim workplane As aWorkplane
Set workplane = part.GetActiveWorkplane

'Get the active sketch
Dim Sketch As aSketch
Set Sketch = part.GetActiveSketch

'Create a VectorClass
Dim vecCls As VectorClass
Set vecCls = app.GetClass("Vector")

'Create a square on the base workplane
Dim vector1 As zVector
Dim vector2 As zVector
Dim vector3 As zVector
Dim vector4 As zVector

Set vector1 = vecCls.CreateVector(-0.1, 0.1, 0#)
Set vector2 = vecCls.CreateVector(0.1, 0.1, 0#)
Set vector3 = vecCls.CreateVector(0.1, -0.1, 0#)
Set vector4 = vecCls.CreateVector(-0.1, -0.1, 0#)

Dim curve1 As zCurve
Dim curve2 As zCurve
Dim curve3 As zCurve
Dim curve4 As zCurve

Dim line1 As aLine
Dim line2 As aLine
Dim line3 As aLine
Dim line4 As aLine

'Create a BasicStraightClass
Dim basicStrCls As BasicStraightClass
Set basicStrCls = app.GetClass("BasicStraight")

Set mat = workplane.GetTransformToPlane
Set curve1 = basicStrCls.CreateBasicStraightTwoPoints(vector1, vector2)
curve1.transform mat
Set line1 = Sketch.CreateLine(curve1)

Set mat = workplane.GetTransformToPlane
Set curve2 = basicStrCls.CreateBasicStraightTwoPoints(vector2, vector3)
curve2.transform mat
Set line2 = Sketch.CreateLine(curve2)

Set mat = workplane.GetTransformToPlane
Set curve3 = basicStrCls.CreateBasicStraightTwoPoints(vector3, vector4)
curve3.transform mat
Set line3 = Sketch.CreateLine(curve3)

Set mat = workplane.GetTransformToPlane
Set curve4 = basicStrCls.CreateBasicStraightTwoPoints(vector4, vector1)
curve4.transform mat
Set line4 = Sketch.CreateLine(curve4)

'Create a SetClass
Dim setCls As ObjectSetClass
Set setCls = app.GetClass("ObjectSet")

Set set1 = setCls.CreateAObjectSet
set1.AddMember line1
set1.AddMember line2
set1.AddMember line3
set1.AddMember line4
Set set2 = setCls.CreateAObjectSet
workplane.AutoConstrainLines set1, set2

'Create an ExtrusionClass
Dim extrusionCls As ExtrusionClass
Set extrusionCls = app.GetClass("Extrusion")

'Extrude the square to create a cube
Dim extrusion1 As aExtrusion
Set extrusion1 = extrusionCls.CreateExtrusion(part.GetDesign, part.GetActiveSketch, 0.2, 0, 0, 0, 1, 0)
extrusion1.SetName "Extrusion1"
part.UpdateDesign
api.CommitCalls "UpdateView", False

End Sub

Private Sub cubeDevelopment()

'Variants to hold edge,edgeCurve,workplane
'sketch,face,zPlane,startPoint,endPoint,x,y co-ordinate
Dim edge(12) As Variant
Dim edgeCurve(12) As Variant

Dim wp(12) As Variant
Dim sk(12) As Variant
Dim face(12) As Variant
Dim wpzPlane(12) As Variant

Dim startPoint(12) As Variant
Dim endPoint(12) As Variant

Dim x(12) As Variant
Dim y(12) As Variant

'Variable to set the value of zero
Dim checkZeroLimit As Double
checkZeroLimit = 0.00000001

'Get the application object
GetApplicationObject

'Get the part document
Dim part As PartDocument
Set part = app.GetActiveDoc()

Dim api As helm
Set api = app.TakeHelm

'Get the base workplane,active sketch of the design
Dim baseWorkplane As aWorkplane
Set baseWorkplane = part.LookupWorkplane("base")
Set initial = part.GetActiveSketch

'Get the lines in the active sketch
Dim lineSet As ObjectSet
Set lineSet = initial.GetLines(True, True)

'Create an IteratorClass object
Dim itCls As ItClass
Set itCls = app.GetClass("It")

Dim lineSetIt As Iterator
Set lineSetIt = itCls.CreateAObjectIt(lineSet)

Dim line0 As aLine
Set line0 = lineSetIt.start

Dim line0StartVec As zVector
Dim line0Startpoint As aPoint
Set line0Startpoint = line0.GetStartPoint()
Set line0StartVec = line0Startpoint.GetPosition
x(0) = line0StartVec.GetAt(0)
y(0) = line0StartVec.GetAt(1)

Dim extr As aExtrusion
Dim design As aDesign

Set design = part.GetDesign
Set extr = design.GetOperation(0)
extrDist = extr.GetDistance

Dim topFace As aFace
Set topFace = extr.GetEndFace(line0, True, True)
Set bottomFace = extr.GetEndFace(line0, True, False)

'Get the design
Set design = part.GetDesign()

'Get the faces of the design
Dim faceSet As ObjectSet
Set faceSet = design.GetFaces

Dim faceSetIt As Iterator
Set faceSetIt = itCls.CreateAObjectIt(faceSet)

Dim faceCollection As New Collection

faceSetIt.start
Do While faceSetIt.IsActive
    
    faceCollection.Add Item:=faceSetIt.Current
    
faceSetIt.Next
Loop

'Get the face count
Dim faceCount As Integer
faceCount = faceSet.GetCount

faceCollectionCount = faceCollection.count

'Iterate through all the faces
For J = 1 To faceCount

    Set face(J) = faceCollection.Item(J)
    
    'Skip if the face is a bottom face
    If (face(J) Is bottomFace) Then
        GoTo incrementJ
    End If
 
    'Get the surrounding edges of the face
    Set edgeset = face(J).GetSurroundingEdges
    'Get the edge count
    edgeCount = edgeset.GetCount
       
    Dim edgeSetIt As Iterator
    Set edgeSetIt = itCls.CreateAObjectIt(edgeset)
    
    Dim edgeCollection As New Collection
    
    edgeSetIt.start
    Do While edgeSetIt.IsActive
        
        edgeCollection.Add Item:=edgeSetIt.Current
        
    edgeSetIt.Next
    Loop
       
    'Iterate through the edges to obtain the base edge and xTranslation,yTranslation
    For s = 1 To edgeCount
    
        Set edge(s) = edgeCollection.Item(s)
        Set edgeCurve(s) = edge(s).GetGeometricForm
        Set startPoint(s) = edgeCurve(s).GetStart
        Set endPoint(s) = edgeCurve(s).GetEnd
        
        'Get the x,y,z co-ordinates of the edge
        xStart1 = startPoint(s).GetAt(0)
        yStart1 = startPoint(s).GetAt(1)
        zStart = startPoint(s).GetAt(2)
        
        xEnd = endPoint(s).GetAt(0)
        yEnd = endPoint(s).GetAt(1)
        zEnd = endPoint(s).GetAt(2)
        
        'Check if the edge lies on the base workplane
        'and set the xTranslation,yTranslation values
        If (zStart < checkZeroLimit And zEnd < checkZeroLimit) Then
        
            'For getting the angle between the x-Axis and the edge
            Set edgeVector = startPoint(s).subtract(endPoint(s))
            Set unitEdgevector = edgeVector.GetUnitVector
            'Get the local X -Axis Vector
            Set XAxisDirection = baseWorkplane.GetLocalX
            xdir = XAxisDirection.GetAt(0)
            ydir = XAxisDirection.GetAt(1)
            zdir = XAxisDirection.GetAt(2)
            'Create a VectorClass
            Dim vecCls As VectorClass
            Set vecCls = app.GetClass("Vector")
            Set XAxisVector = vecCls.CreateVector(xdir, ydir, zdir)
            Set unitXAxisVector = XAxisVector.GetUnitVector
            
            Set faceNormal = face(J).GetGeometricForm.GetNormal
            xdirNormal = faceNormal.GetAt(0)
            ydirNormal = faceNormal.GetAt(1)
            zdirNormal = faceNormal.GetAt(2)
            Set faceNormalVector = vecCls.CreateVector(xdirNormal, ydirNormal, zdirNormal)
            Set unitFaceNormalVector = faceNormalVector.GetUnitVector
            
            cosTheta = unitXAxisVector.Dot(unitFaceNormalVector)
            
            'Get the angle between the edge and the local x-Axis
            cos_of_angle = unitEdgevector.Dot(unitXAxisVector)
            pAngle = Atn(-cos_of_angle / Sqr(-cos_of_angle * cos_of_angle + 1)) + 2 * Atn(1)
            If (cosTheta > 0) Then
                pAngle = (3.142857142857 * 2) - pAngle
            End If
            
            xTr = xStart1
            yTr = yStart1
            
        End If
        
    Next s
    
    'Set the active sketch to the initial sketch
    part.SetActiveSketch (initial)
    
    'Rotate the baseworkplane work axes through the angle obtained
    RotateAxes pAngle
    'Translate the work axes
    TranslateAxes xTr, yTr
    
    'Create a plane of object on top of the face
    Set wp(J) = PlaneOfObject(face(J), "workplane" & J, "sketch" & J, False, 5)
    Set sk(J) = part.GetActiveSketch
    Set wpzPlane(J) = wp(J).GetGeometricForm
    
    'Reverse the PlaneOfObject work axes
    ReverseAxes
    'Translate the work axes
    TranslateAxes xTr, yTr

        'Create a MatrixClass
        Dim matrixCls As MatrixClass
        Set matrixCls = app.GetClass("Matrix")

    Dim identity As zMatrix
    Set identity = matrixCls.CreateScaleMatrix(1)
    
        'Create a SetClass
        Dim setCls As ObjectSetClass
        Set setCls = app.GetClass("ObjectSet")

    Set lineSet2 = setCls.CreateAObjectSet()
    
    edgeCollectionCount = edgeCollection.count
    For i = 1 To edgeCollectionCount
        Set edgeCurve(i) = wp(J).ProjectTopology(edgeCollection.Item(i), identity)
        Set line1 = sk(J).CreateLine(edgeCurve(i))
        lineSet2.AddMember line1
    Next i
    
    Set edgeCollection = Nothing
   
    'Adopt the sketch on the base workplane
    baseWorkplane.AdoptSketch sk(J)
    sk(J).SetName ("sketch" & J)
    sk(J).SetVisible 1
    sk(J).GetLineWidth
    
    If (face(J) Is topFace) Then
        Set topFaceLineSet = sk(J).GetLines(True, True)
        xdist = (line1.GetGeometricForm.GetLength) + extrDist
        TranslateObjects -xdist, 0, topFaceLineSet
    End If
        
incrementJ:

api.CommitCalls "UpdateView", False

Next J          'End of Face iterator

End Sub

Private Function GetApplicationObject()

'Create a ProDESKTOP Application Object if the app object is null
If app Is Nothing Then
    Set app = CreateObject("ProDESKTOP.Application")
End If

'Exit if ProDESKTOP Application object is not created
If app Is Nothing Then
    MsgBox ("Could not create ProDESKTOP Application object")
    Exit Function
End If

End Function

Private Function PlaneOfObject(firstTopology, workplaneName, sketchName, bNoSketch, color)

'Convenience Function to create a workplane on a planar face or in the plane of a circular or elliptical edge

'check if the selected entity belongs to a TopologyClass
If firstTopology Is Nothing Then
    MsgBox ("Enity not Selected")
Else
    Dim blnFirstTopology As Boolean
    blnFirstTopology = firstTopology.IsA("Topology")
End If

If (blnFirstTopology) Then

    'Get the ProDESKTOP Application object
    GetApplicationObject
    
    'Get the active part document
    Dim part As PartDocument
    Set part = app.GetActiveDoc
    
    'Get the Design
    Dim design As aDesign
    Set design = part.GetDesign
    
    'Get the geometry
    Dim geom As zGeometry
    Set geom = firstTopology.GetGeometricForm
    'Get the zPlane
    Dim plane As zPlane
    Set plane = geom
        
    'Check if a workplane of the given name already exists
    Dim Found As Boolean
    Found = False

    Dim currentWorkplane As aWorkplane
    Set currentWorkplane = part.LookupWorkplane(workplaneName)

    If Not currentWorkplane Is Nothing Then
        Found = True
    End If

    If Found Then
        MsgBox ("A workplane already exists with that name. Choose another name")
        Set PlaneOfObject = Nothing
        GoTo endOfFunction
    Else
        'Create the Plane of Object using the zPlane and workplane name
        Set PlaneOfObject = design.CreateWorkplane(plane, workplaneName)
    End If

    'Set the Local Origin
    
        Dim matrixCls As MatrixClass
        Set matrixCls = app.GetClass("Matrix")

    Dim identity As zMatrix
    Set identity = matrixCls.CreateScaleMatrix(1)
    Dim box As zBox
    Set box = plane.GetBoundingBox(identity)
    
    Dim bIsEmpty As Boolean
    bIsEmpty = box.IsEmpty()
    
    If Not bIsEmpty Then
        PlaneOfObject.SetLocalOrigin box.GetCenter
    End If
       
    'Create a sketch with the given sketch name
    If Not bNoSketch Then
    
        Dim PlaneOfObjectSketch As aSketch
        Set PlaneOfObjectSketch = PlaneOfObject.CreateSketch(sketchName)
        
        'Set the color for the sketch
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
                'Create ColorClass object
                Dim colorCls As ColorClass
                Set colorCls = app.GetClass("Color")

        Dim newColor As zColor
        Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)

        PlaneOfObjectSketch.SetColor newColor
        part.SetActiveSketch PlaneOfObjectSketch
           
    End If

Else

    MsgBox ("ImProper Selection of Entities")
    Set PlaneOfObject = Nothing

End If

endOfFunction:
End Function

Private Function ReverseAxes()

'Convenience Function to Reverse the axes of an active workplane

'Get the active Partdocument,Workplane
GetApplicationObject
Dim part As PartDocument
Set part = app.GetActiveDoc
Dim workplane As aWorkplane
Set workplane = part.GetActiveWorkplane

Dim localX As zVector
Dim plocalx As zDirection
Dim localY As zDirection

'Get the x direction
Set plocalx = workplane.GetLocalX
'change the direction of x to GetNegative

Set localX = plocalx.GetNegative

'Create directionClass object
Dim directionCls As DirectionClass
Set directionCls = app.GetClass("Direction")

Dim localxDir As zDirection
Set localxDir = directionCls.CreateDirection(localX.GetAt(0), localX.GetAt(1), localX.GetAt(2))

'Get the y direction
Set localY = workplane.GetLocalY

workplane.SetLocalAxes localxDir, localY

End Function

Private Function TranslateAxes(xTranslation, yTranslation)

'Convenience Function to Translate the origin to a given point

'Get the active Partdocument,Workplane
GetApplicationObject
Dim part As PartDocument
Set part = app.GetActiveDoc
Dim wp As aWorkplane
Set wp = part.GetActiveWorkplane

'Create VectorClass object
Dim vecCls As VectorClass
Set vecCls = app.GetClass("Vector")

'Create an origin vector
Dim vector1 As zVector
Set vector1 = vecCls.CreateVector(xTranslation, yTranslation, 0)

'Get the transformation matrix for translating the origin
Dim transMatrix As zMatrix
      
Dim vector2 As zVector
Dim vector3 As zVector
Dim vector4 As zVector
   
Set vector2 = wp.GetLocalOrigin()
Set vector3 = vector1.subtract(vector2)

'Create MatrixClass object
Dim matrixCls As MatrixClass
Set matrixCls = app.GetClass("Matrix")
  
Set transMatrix = matrixCls.CreateTranslationMatrix(vector3)
  
'Set the new origin
Set localOrigin = wp.GetLocalOrigin
Set vector4 = transMatrix.MultiplyByVector(localOrigin)
wp.SetLocalOrigin vector4
   
Dim dir1 As zDirection
Dim dir2 As zDirection
Dim dir3 As zDirection
Dim dir4 As zDirection
   
Set dir1 = wp.GetLocalX
Set dir2 = wp.GetLocalY
   
Set dir3 = transMatrix.MultiplyByDirection(dir1)
Set dir4 = transMatrix.MultiplyByDirection(dir2)
   
wp.SetLocalAxes dir3, dir4
              
End Function


Private Function RotateAxes(pAngle)

'Conveninece Function to rotate the axes through a specified angle in degrees

'Get the active Partdocument,Workplane
GetApplicationObject
Dim part As PartDocument
Set part = app.GetActiveDoc

Dim workplane As aWorkplane
Set workplane = part.GetActiveWorkplane

'Get the existing origin
Dim origin As zVector
Dim localX  As zDirection
Dim localY As zDirection
Set origin = workplane.GetLocalOrigin()
Set localX = workplane.GetLocalX()
Set localY = workplane.GetLocalY()

Dim cosine As Double
Dim sine As Double

cosine = Cos(pAngle)
sine = Sin(pAngle)

Dim newX As zVector
Dim newY As zVector

Set newX = localX.Multiply(cosine).Add(localY.Multiply(sine))
Set newY = localX.Multiply(-sine).Add(localY.Multiply(cosine))

'Create DirectionClass object
Dim dirCls As DirectionClass
Set dirCls = app.GetClass("Direction")

Dim newXdir As zDirection
Dim newYdir As zDirection

Set newXdir = dirCls.CreateDirection(newX.GetAt(0), newX.GetAt(1), newX.GetAt(2))
Set newYdir = dirCls.CreateDirection(newY.GetAt(0), newY.GetAt(1), newY.GetAt(2))

'Create MatrixClass object
Dim matrixCls As MatrixClass
Set matrixCls = app.GetClass("Matrix")

'Gets the transformation matrix
Dim oldMapping As zMatrix
Dim newMapping As zMatrix
Dim transMatrix As zMatrix

Set oldMapping = matrixCls.CreateTranslationMatrix(origin).MultiplyByMatrix(matrixCls.CreateRotationMatrix(localX, localY))
Set newMapping = matrixCls.CreateTranslationMatrix(origin).MultiplyByMatrix(matrixCls.CreateRotationMatrix(newXdir, newYdir))
Set transMatrix = newMapping.MultiplyByMatrix(oldMapping.GetInverse())

workplane.SetLocalOrigin transMatrix.MultiplyByVector(workplane.GetLocalOrigin)
workplane.SetLocalAxes transMatrix.MultiplyByDirection(workplane.GetLocalX), transMatrix.MultiplyByDirection(workplane.GetLocalY)

End Function

Rem Convenience function to translate the object set

Private Sub TranslateObjects(xDistance, ydistance, objSet)

'To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim part As PartDocument
Set part = app.GetActiveDoc

Dim Sketch As aSketch
Set Sketch = part.GetActiveSketch

Dim wp As aWorkplane
Set wp = part.GetActiveWorkplane

'Create VectorClass object
Dim vecCls As VectorClass
Set vecCls = app.GetClass("Vector")

Rem Create the translation vector
Dim transvect1 As zVector
Set transvect1 = vecCls.CreateVector(xDistance, ydistance, 0)

Dim transvect As zVector
Set transvect = wp.Get3DVector(transvect1).subtract(wp.GetLocalOrigin)

'Create MatrixClass object
Dim matrixCls As MatrixClass
Set matrixCls = app.GetClass("Matrix")

Rem Create the Translation matrix
Dim transMat As zMatrix
Set transMat = matrixCls.CreateTranslationMatrix(transvect)

Rem Perform the transformation on the object set
wp.TransformObjects objSet, transMat

End Sub




